* master.do
* fecha: Enero 25, 2012

clear all

* tamao memoria dataset
set mem 100m

cd "C:\Users\maria\Documents\trabajos\clases\curso-IDRC\wrk\Test-Stata"

* log
capture log close
log using "test.log", replace

* importar base de datos
insheet using "bol05_cedlas-resumida.csv", comma

* etiquetar variable
label variable urbano "urbano / rural"

* etiquetar valores
label define urbano 0 "rural" 1 "urbano"
label values urbano urbano

* descripcion base de datos
describe

* summarize
summarize ipcf
summarize ipcf [w=pondera]
summarize ipcf [w=pondera] if urbano == 1
summarize ipcf [w=pondera] if urbano == 0

* replace
replace itf = itf / 1000
replace hombre = 0 if hombre == 1
replace ipcf = 0 if urbano != 1
replace ipcf = 0 if urbano == 0 & hombre == 1

* guardar base de datos en formato Stata
save "bol05_cedlas-resumida", replace

use "bol05_cedlas-resumida", clear

* table
table region
table region [w=pondera], c(mean ipcf)
table region [w=pondera], c(freq mean ipcf)

* generate
generate edad2 = edad*edad
gen grupo = .
replace grupo = 1 if edad<=10 & hombre==1

* results
summarize ipcf [w=pondera]
gen ipcf_media = ipcf/r(mean)
rename ipcf_media ipcf_mu

* histograma
gen lipcf = log(ipcf)
histogram lipcf

log close


